<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\OptionSource\Filter;

use Magento\Framework\Data\OptionSourceInterface;

class AiStatus extends Fields implements OptionSourceInterface
{
    /*
     * Statuses
     */
    public const ALL = 'all';

    public const NOT_GENERATED = 'not_generated';

    public const WRITETEXTAI = 'writetextai';

    public const NO_ACTIVITY = 'no_activity';

    public const IMAGE_ALT_TEXT = 'image_alt_text';

    /*
     * WriteText.ai Statuses
     */
    public const GENERATED = 'Generated';

    public const TRANSFERRED = 'Transferred';

    public const EDITED = 'Edited';

    public const REVIEWED = 'Reviewed';

    public const FOR_TRANSFERRING = 'ForTransferring';

    /**
     * WriteText.ai Templates
     */
    public const TEMPLATES_SHOW_ALL = 'show_all';

    public const TEMPLATES_ALL = 'all';

    public const NO_TEMPLATE = '00000000-0000-0000-0000-000000000000';

    /**
     * AI Models
     */
    public const AI_MODELS_SHOW_ALL = 'show_all';

    public const AI_MODELS_ALL = 'all';

    public const AI_MODELS_NO_MODEL = '00000000-0000-0000-0000-000000000000';

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $fields = [
            [
                'value' => self::PAGE_TITLE,
                'label' => __('Meta title')
            ],
            [
                'value' => self::PAGE_DESCRIPTION,
                'label' => __('Meta description')
            ],
            [
                'value' => self::PRODUCT_DESCRIPTION,
                'label' => __('Description')
            ],
            [
                'value' => self::EXCERPT,
                'label' => __('Short description')
            ]
        ];

        if ($this->helper->getCustomOpenGraph()) {
            $fields[] = [
                'value' => self::OPEN_GRAPH,
                'label' => __('Open Graph text')
            ];
        }

        $fields[] = [
            'value' => self::IMAGE_ALT_TEXT,
            'label' => __('Image alt text')
        ];

        // Get automatic text optimization for filters
        $automaticTextOptimizationFilters = $this->helper->getAutomaticTextOptimizationOptions(true);
        $templatesOptions = $this->templateOptionsForProduct();
        $aiModelsOptions = $this->aiModelOptionsForProduct();

        $statuses = [
            'fields' => $fields,
            'statuses' => [
                [
                    'value' => self::ALL,
                    'label' => __('All')
                ],
                [
                    'value' => self::NOT_GENERATED,
                    'label' => __('Not generated')
                ],
                [
                    'value' => self::WRITETEXTAI,
                    'label' => __('WriteText.ai status')
                ]
            ],
            'ai_statuses' => [
                [
                    'value' => self::GENERATED,
                    'label' => __('Generated')
                ],
                [
                    'value' => self::EDITED,
                    'label' => __('Edited')
                ],
                [
                    'value' => self::REVIEWED,
                    'label' => __('Reviewed')
                ],
                // [
                //     'value' => self::FOR_TRANSFERRING,
                //     'label' => __('Queued for transfer')
                // ],
                [
                    'value' => self::TRANSFERRED,
                    'label' => __('Transferred')
                ]
            ],
            'no_activity_value' => [
                'value' => self::NO_ACTIVITY,
                'label' => __('No Activity')
            ],
            'writetextai_status_value' => [
                'value' => self::WRITETEXTAI,
                'label' => __('WriteText.ai status')
            ],
            'automatic_text_optimization' => $automaticTextOptimizationFilters,
            'templates' => $templatesOptions,
            'ai_models' => $aiModelsOptions
        ];

        return $statuses;
    }
    
    /**
     * Get options
     *
     * @return array
     */
    public function templateOptionsForProduct()
    {
        $options = [
            [
                'value' => self::TEMPLATES_SHOW_ALL,
                'label' => __('All')
            ],
            [
                'value' => self::PAGE_TITLE,
                'label' => __('Meta title'),
                'options' => $this->getTemplateOptions(self::PAGE_TITLE)
            ],
            [
                'value' => self::PRODUCT_DESCRIPTION,
                'label' => __('Description'),
                'options' => $this->getTemplateOptions(self::PRODUCT_DESCRIPTION)
            ],
            [
                'value' => self::EXCERPT,
                'label' => __('Short description'),
                'options' => $this->getTemplateOptions(self::EXCERPT)
            ]
        ];
        
        return $options;
    }

    /**
     * Get template options
     *
     * @param string $field
     * @return array
     */
    protected function getTemplateOptions($field)
    {
        $options = [
            [
                'id' => '',
                'name' => __('Select template')
            ],
            [
                'id' => self::NO_TEMPLATE,
                'name' => __('No template')
            ]
        ];
        $templates = $this->getCurrentTemplateSettings($field);
        return array_merge($options, $templates);
    }

    /**
     * Get options
     *
     * @return array
     */
    public function aiModelOptionsForProduct()
    {
        $options = [
            [
                'value' => self::AI_MODELS_SHOW_ALL,
                'label' => __('All')
            ],
            [
                'value' => self::PAGE_TITLE,
                'label' => __('Meta title'),
                'options' => $this->getAiModelOptions()
            ],
            [
                'value' => self::PRODUCT_DESCRIPTION,
                'label' => __('Description'),
                'options' => $this->getAiModelOptions()
            ],
            [
                'value' => self::EXCERPT,
                'label' => __('Short description'),
                'options' => $this->getAiModelOptions()
            ]
        ];
        
        return $options;
    }

    /**
     * Get AI model options
     *
     * @return array
     */
    protected function getAiModelOptions()
    {
        $options = [
            [
                'id' => self::AI_MODELS_NO_MODEL,
                'name' => __('No ai model')
            ]
        ];
        $aiModels = $this->aiModels->getAvailableAiModels();
        if (count($aiModels) > 0) {
            $options[] = [
                'id' => self::AI_MODELS_ALL,
                'name' => __('All')
            ];
        }
        return array_merge($options, $aiModels);
    }
}
