<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Config\Source;

class DisallowedHtml
{
    public const ALLOWED_TAGS = '<ul><li><ol><p><blockquote><strong><em><pre>' .
        '<del><h1><h2><h3><h4><h5><h6><a><hr><br /><span><u>' .
        '<div><table><tbody><tr><td><caption>';

    public const ALLOWED_ATTRIBUTES = [
        'a' => ['href', 'title', 'target', 'rel'],
        'table' => ['style', 'border', 'cellpadding', 'cellspacing'],
        'td' => ['style'],
        'p' => ['style'],
        'span' => ['style']
    ];

    public const ALLOWED_STYLES = [
        'p' => ['text-align'],
        'span' => ['color', 'text-decoration', 'background-color', 'line-height'],
        'li' => ['text-align'],
        'td' => ['width', 'height'],
        'table' => ['*']
    ];
}
