<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class CategoryTexts implements OptionSourceInterface
{
    public const DEFAULT_PRODUCT_TEXTS = [
        "page_title" => "Meta title",
        "page_description" => "Meta description",
        "category_description" => "Category description",
    ];

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options = [];
        foreach (self::DEFAULT_PRODUCT_TEXTS as $key => $value) {
            $options[] = [
                'value' => $key,
                'label' => __($value)
            ];
        }
        return $options;
    }
}
