<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Categories\OptionSource\Filter;

use Magento\Framework\Data\OptionSourceInterface;
use WriteTextAI\WriteTextAI\Model\OptionSource\Filter\Fields;

class AiStatus extends Fields implements OptionSourceInterface
{
    /*
     * Statuses
     */
    public const ALL = 'all';

    public const NOT_GENERATED = 'not_generated';

    public const WRITETEXTAI = 'writetextai';

    public const NO_ACTIVITY = 'no_activity';

    /*
     * WriteText.ai Statuses
     */
    public const GENERATED = 'Generated';

    public const TRANSFERRED = 'Transferred';

    public const EDITED = 'Edited';

    public const REVIEWED = 'Reviewed';

    public const FOR_TRANSFERRING = 'ForTransferring';

    /**
     * WriteText.ai Templates
     */
    public const TEMPLATES_SHOW_ALL = 'show_all';

    public const TEMPLATES_ALL = 'all';

    public const NO_TEMPLATE = '00000000-0000-0000-0000-000000000000';

    /**
     * AI Models
     */
    public const AI_MODELS_SHOW_ALL = 'show_all';

    public const AI_MODELS_ALL = 'all';

    public const AI_MODELS_NO_MODEL = '00000000-0000-0000-0000-000000000000';

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $categoryMapping = self::CATEGORY_MAPPING;
        $fields = [
            [
                'value' => $categoryMapping['page_title'],
                'label' => __('Meta title')
            ],
            [
                'value' => $categoryMapping['page_description'],
                'label' => __('Meta description')
            ],
            [
                'value' => $categoryMapping['category_description'],
                'label' => __('Category description')
            ]
        ];

        // Get automatic text optimization for filters
        $automaticTextOptimizationFilters = $this->helper->getAutomaticTextOptimizationOptions(true);
        $templatesOptions = $this->templateOptionsForCategory();
        $aiModelsOptions = $this->aiModelOptionsForCategory();

        $statuses = [
            'fields' => $fields,
            'statuses' => [
                [
                    'value' => self::ALL,
                    'label' => __('All')
                ],
                [
                    'value' => self::NOT_GENERATED,
                    'label' => __('Not generated')
                ],
                [
                    'value' => self::WRITETEXTAI,
                    'label' => __('WriteText.ai status')
                ]
            ],
            'ai_statuses' => [
                [
                    'value' => self::GENERATED,
                    'label' => __('Generated')
                ],
                [
                    'value' => self::EDITED,
                    'label' => __('Edited')
                ],
                [
                    'value' => self::REVIEWED,
                    'label' => __('Reviewed')
                ],
                // [
                //     'value' => self::FOR_TRANSFERRING,
                //     'label' => __('Queued for transfer')
                // ],
                [
                    'value' => self::TRANSFERRED,
                    'label' => __('Transferred')
                ]
            ],
            'no_activity_value' => [
                'value' => self::NO_ACTIVITY,
                'label' => __('No Activity')
            ],
            'writetextai_status_value' => [
                'value' => self::WRITETEXTAI,
                'label' => __('WriteText.ai status')
            ],
            'automatic_text_optimization' => $automaticTextOptimizationFilters,
            'templates' => $templatesOptions,
            'ai_models' => $aiModelsOptions
        ];

        return $statuses;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function templateOptionsForCategory()
    {
        $options = [
            [
                'value' => self::TEMPLATES_SHOW_ALL,
                'label' => __('All')
            ],
            [
                'value' => self::CATEGORY_PAGE_TITLE,
                'label' => __('Meta title'),
                'options' => $this->getTemplateOptions(self::CATEGORY_PAGE_TITLE)
            ],
            [
                'value' => self::CATEGORY_DESCRIPTION,
                'label' => __('Description'),
                'options' => $this->getTemplateOptions(self::CATEGORY_DESCRIPTION)
            ]
        ];
        
        return $options;
    }

    /**
     * Get template options
     *
     * @param string $field
     * @return array
     */
    protected function getTemplateOptions($field)
    {
        $options = [
            [
                'id' => '',
                'name' => __('Select template')
            ],
            [
                'id' => self::NO_TEMPLATE,
                'name' => __('No template')
            ]
        ];
        $templates = $this->getCurrentTemplateSettings($field);
        return array_merge($options, $templates);
    }

    /**
     * Get options
     *
     * @return array
     */
    public function aiModelOptionsForCategory()
    {
        $options = [
            [
                'value' => self::AI_MODELS_SHOW_ALL,
                'label' => __('All')
            ],
            [
                'value' => self::CATEGORY_PAGE_TITLE,
                'label' => __('Meta title'),
                'options' => $this->getAiModelOptions()
            ],
            [
                'value' => self::CATEGORY_DESCRIPTION,
                'label' => __('Description'),
                'options' => $this->getAiModelOptions()
            ]
        ];
        
        return $options;
    }

    /**
     * Get AI model options
     *
     * @return array
     */
    protected function getAiModelOptions()
    {
        $options = [
            [
                'id' => self::AI_MODELS_NO_MODEL,
                'name' => __('No ai model')
            ]
        ];
        $aiModels = $this->aiModels->getAvailableAiModels();
        if (count($aiModels) > 0) {
            $options[] = [
                'id' => self::AI_MODELS_ALL,
                'name' => __('All')
            ];
        }
        return array_merge($options, $aiModels);
    }
}
