<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Categories;

use WriteTextAI\WriteTextAI\Model\Categories\GeneratedText;

class MarkReview
{
    /**
     * @var GeneratedText
     */
    protected $generatedText;

    /**
     * Constructor
     *
     * @param GeneratedText $generatedText
     */
    public function __construct(
        GeneratedText $generatedText
    ) {
        $this->generatedText = $generatedText;
    }

    /**
     * Get texts review
     *
     * @param int $categoryId
     * @param int $storeId
     * @param array $text
     * @return bool
     */
    public function getReviewed($categoryId, $storeId, $text = [])
    {
        $text = !empty($text) ? $text : $this->generatedText->getGenerated($categoryId, $storeId, 'Category');

        if (!isset($text['records']) || empty($text['records'])) {
            return false;
        }

        $fieldsReviewed = [];
        foreach ($text['records'] as $record) {
            if ($record['recordId'] === $categoryId && isset($record['stores'])) {
                foreach ($record['stores'] as $store) {
                    if ($store['storeId'] === $storeId) {
                        if (isset($store['texts'][0]['history'][0]['reviewed'])) {
                            $fieldsReviewed[] = $store['texts'][0]['history'][0]['reviewed'];
                        } else {
                            $fieldsReviewed[] = false;
                        }
                    }
                }
            }
        }

        return !empty($fieldsReviewed) && in_array(true, $fieldsReviewed);
    }
}
