<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model;

use WriteTextAI\WriteTextAI\Model\ApiManager;
use WriteTextAI\WriteTextAI\Helper\Store as StoreHelper;

class ArchiveManager
{
    /**
     * @var ApiManager
     */
    protected $apiManager;

    /**
     * @var StoreHelper
     */
    protected $storeHelper;

    /**
     * Constructor
     *
     * @param ApiManager $apiManager
     * @param StoreHelper $storeHelper
     */
    public function __construct(
        ApiManager $apiManager,
        StoreHelper $storeHelper
    ) {
        $this->apiManager = $apiManager;
        $this->storeHelper = $storeHelper;
    }

    /**
     * Archive records
     *
     * @param string $recordId
     * @param string $type
     * @return array
     */
    public function archiveRecord($recordId, $type = 'Product')
    {
        try {
            $body = [
                'recordId' => $recordId,
                'type' => $type
            ];
            return $this->apiManager->archiveRecord($body);
        } catch (\Exception $e) {
            return false;
        }
    }
}
