<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Api;

use WriteTextAI\WriteTextAI\Model\Api\CurlBuilder;

/**
 * @api
 */
class AIModels
{
    /**
     * @var CurlBuilder
     */
    protected $curlBuilder;

    /**
     * Constructor
     *
     * @param CurlBuilder $curlBuilder
     */
    public function __construct(
        CurlBuilder $curlBuilder
    ) {
        $this->curlBuilder = $curlBuilder;
    }

    /**
     * Gets the list of selected AI model IDs for the current user's webshop (UrlId).
     *
     * @return array
     */
    public function getCurrentAIModelSettings()
    {
        return []; //$this->curlBuilder->getApiResponse('web/AIModelSettings/current');
    }

    /**
     * Send products and categories data to WriteTextAI
     *
     * @param array $body Array with structure:
     *     {
     *       "products": [
     *         {
     *           "recordId": "string",
     *           "language": "string",
     *           "name": "string",
     *           "pageTitle": "string",
     *           "pageDescription": "string",
     *           "excerpt": "string",
     *           "openGraphText": "string",
     *           "productDescription": "string",
     *           "sku": "string",
     *           "url": "string",
     *           "categoryRecordIds": ["string"]
     *         }
     *       ],
     *       "categories": [
     *         {
     *           "recordId": "string",
     *           "language": "string",
     *           "name": "string",
     *           "pageTitle": "string",
     *           "pageDescription": "string",
     *           "openGraphText": "string",
     *           "categoryDescription": "string",
     *           "url": "string"
     *         }
     *       ]
     *     }
     * @return array
     */
    public function sendProductsData($body = [])
    {
        return $this->curlBuilder->getApiResponse(
            'text/Catalog/Product/Batch',
            json_encode($body),
            'post'
        );
    }
}
