<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Logger;

use WriteTextAI\WriteTextAI\Helper\Data;

class Logger extends \Monolog\Logger
{
    /**
     * @var Data
     */
    protected $helper;

    /**
     * Logger constructor.
     *
     * @param Data $helper
     * @param string $name
     * @param array $handlers
     * @param array $processors
     */
    public function __construct(
        Data $helper,
        string $name,
        $handlers = [],
        $processors = []
    ) {
        $this->helper = $helper;

        parent::__construct(
            $name,
            $handlers,
            $processors
        );
    }

    /**
     * Logs response errors
     *
     * @param string $message
     * @param string $requestUrl
     * @param array $requestBody
     *
     * @return void
     */
    public function logResponseErrors($message, $requestUrl, $requestBody = [])
    {
        if ($this->helper->isLoggerEnabled()) {
            $this->error('Error: ', [$requestUrl, $requestBody, $message]);
        }
    }
    /**
     * Logs request
     *
     * @param string $request
     * @param array $body
     *
     * @return void
     */
    public function logRequest($request, $body = [])
    {
        if ($this->helper->isLoggerEnabled()) {
            $this->info('Request: ', [$request, $body]);
        }
    }

    /**
     * Logs response
     *
     * @param int $responseCode
     * @param mixed $responseBody
     *
     * @return void
     */
    public function logResponse($responseCode, $responseBody)
    {
        if ($this->helper->isLoggerEnabled()) {
            $this->info('Response: ', [$responseCode, $responseBody]);
        }
    }
}
