<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Helper;

use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Helper\Context;
use WriteTextAI\WriteTextAI\Model\ApiManager;
use Magento\Framework\App\Config\ConfigResource\ConfigInterface;
use Magento\Backend\Helper\Data as BackendHelper;

class Statistics extends \Magento\Framework\App\Helper\AbstractHelper
{
    public const STATISTICS_SETUP1_CONFIG_PATH = 'writetextai_settings/setup/setup1_sent';

    public const STATISTICS_SETUP2_CONFIG_PATH = 'writetextai_settings/setup/setup2_sent';

    public const STATISTICS_SETUP3_CONFIG_PATH = 'writetextai_settings/setup/setup3_sent';

    public const STATISTICS_SETUP4_CONFIG_PATH = 'writetextai_settings/setup/setup4_sent';

    public const STATISTICS_SETUP5_CONFIG_PATH = 'writetextai_settings/setup/setup5_sent';

    /**
     * @var Context
     */
    protected $context;

    /**
     * @var ApiManager
     */
    protected $apiManager;

    /**
     * @var ConfigInterface
     */
    protected $configManager;

    /**
     * @var BackendHelper
     */
    protected $backendHelper;

    /**
     * Constructor
     *
     * @param Context $context
     * @param ApiManager $apiManager
     * @param ConfigInterface $configManager
     * @param BackendHelper $backendHelper
     */
    public function __construct(
        Context $context,
        ApiManager $apiManager,
        ConfigInterface $configManager,
        BackendHelper $backendHelper
    ) {
        $this->apiManager = $apiManager;
        $this->configManager = $configManager;
        $this->backendHelper = $backendHelper;
        parent::__construct($context);
    }

    /**
     * Send statistics
     *
     * @param string $step
     * @return bool
     */
    public function sendStatistics($step)
    {
        try {
            $action = "";
            switch ($step) {
                case 'step1':
                    $confPath = self::STATISTICS_SETUP1_CONFIG_PATH;
                    $action = "Visited Setup page";
                    break;
                case 'step2':
                    $confPath = self::STATISTICS_SETUP2_CONFIG_PATH;
                    $action = "Linked webshop";
                    break;
                case 'step3':
                    $confPath = self::STATISTICS_SETUP3_CONFIG_PATH;
                    $action = "Mapped fields";
                    break;
                case 'step4':
                    $confPath = self::STATISTICS_SETUP4_CONFIG_PATH;
                    $action = "Step 4";
                    break;
                case 'step5':
                    $confPath = self::STATISTICS_SETUP5_CONFIG_PATH;
                    $action = "Visited grid after setup";
                    break;
                default:
                    # code...
                    break;
            }

            if (!$this->conf($confPath)) {
                $data = [
                    "platform" => "Magento",
                    "domain" => $this->getHost(),
                    "action" => $action,
                    "count" => 0
                ];
                $this->apiManager->sendStatistics(json_encode($data));

                $this->configManager->saveConfig($confPath, 1, 'default');
            }
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }

    /**
     * Get config value
     *
     * @param string $path
     * @param int|null $storeId
     * @return mixed
     */
    public function conf($path, $storeId = null)
    {
        return $this->scopeConfig->getValue($path, 'default');
    }

    /**
     * Get current host
     *
     * @return string
     */
    public function getHost()
    {
        $url = str_replace(
            ['http://', 'https://'],
            '',
            $this->backendHelper->getUrl()
        );

        return rtrim($url, '/');
    }
}
