<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Settings;

use WriteTextAI\WriteTextAI\Model\Api\CurlBuilder;
use WriteTextAI\WriteTextAI\Helper\Data;
use Magento\Framework\Event\ManagerInterface as EventManager;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultInterface;
use WriteTextAI\WriteTextAI\Model\Api\Session as ApiSession;
use WriteTextAI\WriteTextAI\ViewModel\UserFieldsSelected;
use WriteTextAI\WriteTextAI\Model\UserFieldsSelectedManager;

class Index extends \Magento\Backend\App\Action
{
    /**
     * @var CurlBuilder
     */
    protected $curlBuilder;

    /**
     * @var Data
     */
    protected $helper;

    /**
     * @var EventManager
     */
    protected $eventManager;

    /**
     * @var ApiSession
     */
    protected $apiSession;

    /**
     * @var UserFieldsSelected
     */
    protected $userFieldsSelected;

    /**
     * Constructor
     *
     * @param Context $context
     * @param CurlBuilder $curlBuilder
     * @param Data $helper
     * @param EventManager $eventManager
     * @param ApiSession $apiSession
     * @param UserFieldsSelected $userFieldsSelected
     */
    public function __construct(
        Context $context,
        CurlBuilder $curlBuilder,
        Data $helper,
        EventManager $eventManager,
        ApiSession $apiSession,
        UserFieldsSelected $userFieldsSelected
    ) {
        $this->curlBuilder = $curlBuilder;
        $this->helper = $helper;
        $this->eventManager = $eventManager;
        $this->apiSession = $apiSession;
        $this->userFieldsSelected = $userFieldsSelected;
        parent::__construct($context);
    }

    /**
     * Index action
     *
     * @return ResultInterface
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $userlanguage = $this->apiSession->getRegionIndependentLanguage();
        $translationNoticeEnabled = $this->helper->isTranslationNoticeEnabled();

        try {
            if (!$this->isLoggedIn()) {
                return $resultRedirect->setPath('wtai/setup/index');
            } else {
                $this->eventManager->dispatch('wtai_prepare_settings');
                
                if ($userlanguage !== 'en' && $translationNoticeEnabled) {
                    $this->messageManager->addNotice(
                        __("Notice: Translation of extension help text and labels is ongoing. Please stay tuned.")
                    );
                }

                return $resultRedirect->setPath('adminhtml/system_config/edit/section/writetextai_settings');
            }
        } catch (\WriteTextAI\WriteTextAI\Exception\UnauthorizedException $e) {
            return $resultRedirect->setPath('wtai/setup/index');
        } catch (\WriteTextAI\WriteTextAI\Exception\VersionException $e) {
            return $resultRedirect->setPath('wtai/grid/index');
        }
    }

    /**
     * Check if atleast logged in
     *
     * @return bool
     */
    private function isLoggedIn()
    {
        $accountToken = $this->helper->getAccountToken();
        $region = $this->helper->getRegion();

        /**
         * check if account token and region is set
         * then verify account token
         */
        if ($accountToken &&
            $region &&
            $this->curlBuilder->getConnectToken($accountToken)
        ) {
            return true;
        }

        return false;
    }
}
