<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Grid;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\Model\ApiManager;

class GetPingStatus extends Action
{
    /**
     * @var ApiManager
     */
    protected $apiManager;

    /**
     * Constructor
     *
     * @param Context $context
     * @param ApiManager $apiManager
     */
    public function __construct(
        Context $context,
        ApiManager $apiManager
    ) {
        $this->apiManager = $apiManager;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return Json
     */
    public function execute()
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        $link = 'https://writetext.ai/using-writetext-ai/how-do-i-fix-writetext'
            . '-ai-rest-api-communication-issues-for-bulk-actions';
        $pingData = $this->pingApi();
        $message = sprintf("<p><strong>%s</strong></p>", __("We couldn’t start this bulk action."));
        $message .= sprintf("<p>%s</p>", __("WriteText.ai is currently unable to communicate with your"
            . " site through the so-called REST API. Bulk actions depend on this connection, so they"
            . " cannot continue until the connection is allowed."));
        $message .= sprintf("<p>%s</p>", __("You can still do single-product actions, which do not rely"
            . " on the REST API and continue to work normally."));
        $message .= sprintf("<p>%s <a href='%s' target='_blank'/>%s</a></p>",
            __("For steps on how to allow WriteText.ai to communicate with"
                . " your site, please see our troubleshooting guide: "),
            $link,
            __("View REST API connection troubleshooting guide  →"));
        
        $message .= sprintf("<p>%s <a href='https://writetext.ai/create-a-ticket' target='_blank'/>%s</a>, %s</p>",
            __("If you need help, your developer or hosting provider can assist, or you can"),
            __("create a support ticket"),
            __("and our team will be happy to help."));
        if ($pingData['success'] === true) {
            $response->setData([
                'success' => true,
                'pingData' => $pingData,
                'message' => __('Success ping')
            ]);
        } else {
            $response->setData([
                'success' => false,
                'pingData' => $pingData,
                'message' => $message
            ]);
        }

        return $response;
    }

    /**
     * Ping API
     *
     * @return array
     */
    public function pingApi()
    {
        try {
            return $this->apiManager->pingApi();
        } catch (\WriteTextAI\WriteTextAI\Exception\UnauthorizedException $e) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
        }
    }
}
