<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Grid;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\Model\BulkRequestsManager;
use WriteTextAI\WriteTextAI\Model\BulkTransferRequestsManager;

class GetBulkRequests extends Action
{
    /**
     * @var BulkRequestsManager
     */
    protected $bulkRequestsManager;

    /**
     * @var BulkTransferRequestsManager
     */
    protected $bulkTransferRequestsManager;

    /**
     * Constructor
     *
     * @param Context $context
     * @param BulkRequestsManager $bulkRequestsManager
     * @param BulkTransferRequestsManager $bulkTransferRequestsManager
     */
    public function __construct(
        Context $context,
        BulkRequestsManager $bulkRequestsManager,
        BulkTransferRequestsManager $bulkTransferRequestsManager
    ) {
        $this->bulkRequestsManager = $bulkRequestsManager;
        $this->bulkTransferRequestsManager = $bulkTransferRequestsManager;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return \Magento\Framework\Controller\Result\Json
     */
    public function execute()
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        try {
            // Get all bulk requests following the same pattern as ProgressBar block
            $bulkRequests = $this->bulkRequestsManager->getBulkRequests();
            //$transferStatuses = $this->bulkTransferRequestsManager->getBulkRequests();

            // Merge all statuses like in the ProgressBar getStatuses() method
            //$allStatuses = array_merge($generateStatuses, $);
            
            $response->setData([
                'success' => true,
                'bulk_requests' => [
                    'all_statuses' => $bulkRequests
                    //'transfer_statuses' => $transferStatuses,
                ],
                'message' => __('Bulk requests fetched successfully')
            ]);
        } catch (\Exception $e) {
            $response->setData([
                'success' => false,
                'message' => __('Error fetching bulk requests: %1', $e->getMessage()),
                'bulk_requests' => []
            ]);
        }

        return $response;
    }
}
