<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Grid;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\Model\BulkGenerateRequestsManager;
use WriteTextAI\WriteTextAI\Model\BulkTransferRequestsManager;
use WriteTextAI\WriteTextAI\Model\BulkKeywordAnalysisRequestsManager;
use WriteTextAI\WriteTextAI\Model\FullAutomationRequestsManager;

class DismissMessage extends Action
{
    /**
     * @var BulkGenerateRequestsManager
     */
    protected $bulkGenerateRequestsManager;

    /**
     * @var BulkTransferRequestsManager
     */
    protected $bulkTransferRequestsManager;

    /**
     * @var BulkKeywordAnalysisRequestsManager
     */
    protected $bulkKeywordAnalysisRequestsManager;

    /**
     * @var FullAutomationRequestsManager
     */
    protected $fullAutomationRequestsManager;

    /**
     * Constructor
     *
     * @param Context $context
     * @param BulkGenerateRequestsManager $bulkGenerateRequestsManager
     * @param BulkTransferRequestsManager $bulkTransferRequestsManager
     * @param BulkKeywordAnalysisRequestsManager $bulkKeywordAnalysisRequestsManager
     * @param FullAutomationRequestsManager $fullAutomationRequestsManager
     */
    public function __construct(
        Context $context,
        BulkGenerateRequestsManager $bulkGenerateRequestsManager,
        BulkTransferRequestsManager $bulkTransferRequestsManager,
        BulkKeywordAnalysisRequestsManager $bulkKeywordAnalysisRequestsManager,
        FullAutomationRequestsManager $fullAutomationRequestsManager
    ) {
        $this->bulkGenerateRequestsManager = $bulkGenerateRequestsManager;
        $this->bulkTransferRequestsManager = $bulkTransferRequestsManager;
        $this->bulkKeywordAnalysisRequestsManager = $bulkKeywordAnalysisRequestsManager;
        $this->fullAutomationRequestsManager = $fullAutomationRequestsManager;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return \Magento\Framework\Controller\Result\Json
     */
    public function execute()
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        try {
            $requestId = $this->getRequest()->getParam('request_id');
            $transferUser = $this->getRequest()->getParam('transfer_user');
            $type = $this->getRequest()->getParam('type');

            switch ($type) {
                case 'keyword_analysis':
                    if ($requestId) {
                        $this->bulkKeywordAnalysisRequestsManager->delete($requestId);
                    }
                    break;
                case 'full_automation':
                    if ($requestId) {
                        $this->fullAutomationRequestsManager->delete($requestId);
                    }
                    break;
                case 'transfer':
                    if ($transferUser) {
                        $this->bulkTransferRequestsManager->delete($transferUser);
                    }
                    break;
                case 'generate':
                    if ($requestId) {
                        $this->bulkGenerateRequestsManager->delete($requestId);
                    }
                    break;
                default:
                    $this->bulkGenerateRequestsManager->deleteAll();
                    $this->bulkKeywordAnalysisRequestsManager->deleteAll();
                    $this->fullAutomationRequestsManager->deleteAll();
                    $this->bulkTransferRequestsManager->deleteAll();
            }

            $result = [
                'success' => true
            ];
        } catch (\Exception $e) {
            $message = $e->getMessage();
            if (!$message) {
                $message = __(
                    'A system error has occurred. Please try again. If the issue persists,'
                    . ' please contact our support team at support@writetext.ai.'
                );
            }
            
            $result = [
                'success' => false,
                'message' => $message
            ];
        }

        $response->setData($result);

        return $response;
    }
}
