<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Edit\Pronouns;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\Model\UserFieldsSelectedManager;

class Highlighted extends Action
{
    /**
     * @var UserFieldsSelectedManager
     */
    protected $userFieldsSelectedManager;

    /**
     * Constructor
     *
     * @param Context $context
     * @param UserFieldsSelectedManager $userFieldsSelectedManager
     */
    public function __construct(
        Context $context,
        UserFieldsSelectedManager $userFieldsSelectedManager
    ) {
        $this->userFieldsSelectedManager = $userFieldsSelectedManager;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return \Magento\Framework\Controller\Result\Json
     */
    public function execute()
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);

        try {
            $highlighted = $this->getRequest()->getParam('highlighted');
            $entityType = $this->getRequest()->getParam('entity_type', 'product');
            
            $this->userFieldsSelectedManager->saveUserFieldsSelected(
                $highlighted,
                UserFieldsSelectedManager::ACTION_TYPE_HIGHLIGHT_PRONOUNS,
                '',
                'edit'
            );
            
            $result = [
                'success' => true
            ];
        } catch (\Exception $e) {
            $message = $e->getMessage();
            if (!$message) {
                $message = __(
                    'A system error has occurred. Please try again. If the issue persists,'
                    . ' please contact our support team at support@writetext.ai.'
                );
            }
            
            $result = [
                'success' => false,
                'message' => $message
            ];
        }

        $response->setData($result);

        return $response;
    }
}
