<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Block;

use Magento\Framework\View\Element\Template\Context;
use Magento\Framework\Encryption\EncryptorInterface;
use WriteTextAI\WriteTextAI\Model\UserWebTokenManager;

class Meta extends \Magento\Framework\View\Element\Template
{
    /**
     * @var EncryptorInterface
     */
    protected $encryptor;

    /**
     * @var UserWebTokenManager
     */
    protected $userWebTokenManager;

    /**
     * Constructor
     *
     * @param Context $context
     * @param EncryptorInterface $encryptor
     * @param UserWebTokenManager $userWebTokenManager
     * @param array $data
     */
    public function __construct(
        Context $context,
        EncryptorInterface $encryptor,
        UserWebTokenManager $userWebTokenManager,
        array $data = []
    ) {
        $this->encryptor = $encryptor;
        $this->userWebTokenManager = $userWebTokenManager;
        parent::__construct($context, $data);
    }

    /**
     * Get content
     *
     * @return string
     */
    public function getContent()
    {
        try {
            return sha1($this->getHost());
        } catch (\Exception $e) {
            return '';
        }
    }

    /**
     * Get URL ID from token
     *
     * @return string
     */
    public function getUid()
    {
        $urlId = '';
        try {
            $token = $this->userWebTokenManager->getFirstUserWebToken();
            // phpcs:disable Magento2.Functions.DiscouragedFunction.Discouraged
            $decoded = json_decode(
                base64_decode(str_replace('_', '/', str_replace('-', '+', explode('.', $token)[1]))),
                true
            );
            // phpcs:enable Magento2.Functions.DiscouragedFunction.Discouraged
            if (isset($decoded['url_id'])) {
                $urlId = $decoded['url_id'];
            }
        } catch (\Exception $e) {
            $urlId = '';
        }
        return $urlId;
    }

    /**
     * Get Store ID
     *
     * @return string
     */
    public function getSid()
    {
        return $this->_storeManager->getStore()->getId();
    }

    /**
     * Get current host
     *
     * @return string
     */
    public function getHost()
    {
        $url = str_replace(
            ['http://', 'https://'],
            '',
            $this->getBaseUrl()
        );
        $url = str_replace('index.php', '', $url);

        return rtrim($url, '/');
    }
}
