<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Block\Adminhtml\System\Config;

use Magento\Config\Block\System\Config\Form as MagentoForm;
use WriteTextAI\WriteTextAI\ViewModel\Premium;
use WriteTextAI\WriteTextAI\ViewModel\Popups;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Registry;
use Magento\Framework\Data\FormFactory;
use Magento\Config\Model\Config\Factory;
use Magento\Config\Model\Config\Structure;
use Magento\Config\Block\System\Config\Form\Fieldset\Factory as FieldsetFactory;
use Magento\Config\Block\System\Config\Form\Field\Factory as FieldFactory;
use Magento\Config\Model\Config\Reader\Source\Deployed\SettingChecker;
use WriteTextAI\WriteTextAI\Model\ApiManager;
use Magento\Framework\Message\ManagerInterface;

class Form extends MagentoForm
{
    /**
     * @var Premium
     */
    protected $premium;

    /**
     * @var Popups
     */
    protected $popups;

    /**
     * @var ApiManager
     */
    protected $apiManager;

    /**
     * @var ManagerInterface
     */
    protected $messageManager;

    /**
     * @param Premium $premium
     * @param Popups $popups
     * @param ApiManager $apiManager
     * @param ManagerInterface $messageManager
     * @param Context $context
     * @param Registry $registry
     * @param FormFactory $formFactory
     * @param Factory $configFactory
     * @param Structure $configStructure
     * @param FieldsetFactory $fieldsetFactory
     * @param FieldFactory $fieldFactory
     * @param array $data
     * @param SettingChecker $settingChecker
     */
    public function __construct(
        Premium $premium,
        Popups $popups,
        ApiManager $apiManager,
        ManagerInterface $messageManager,
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        Factory $configFactory,
        Structure $configStructure,
        FieldsetFactory $fieldsetFactory,
        FieldFactory $fieldFactory,
        array $data = [],
        ?SettingChecker $settingChecker = null
    ) {
        $this->premium = $premium;
        $this->popups = $popups;
        $this->apiManager = $apiManager;
        $this->messageManager = $messageManager;
        parent::__construct(
            $context,
            $registry,
            $formFactory,
            $configFactory,
            $configStructure,
            $fieldsetFactory,
            $fieldFactory,
            $data,
            $settingChecker
        );
    }

    /**
     * @inheritdoc
     */
    public function _toHtml()
    {
        if (!$this->premium->getHasProAccess()
            && $this->premium->getMembershipType() === Premium::MEMBERSHIP_TYPE_FREE_TRIAL) {
            $block = $this->_layout->createBlock(\WriteTextAI\WriteTextAI\Block\Adminhtml\Popups\EndTrial::class);
            $block->addData([
                'premium' => $this->premium,
                'popups' => $this->popups
            ]);
            $html = $block->toHtml();
            return $html;
        }

        $html = parent::_toHtml();
        
        return $html;
    }
}
