<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Block\Adminhtml;

use Magento\Backend\Block\Template;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\UrlInterface;
use WriteTextAI\WriteTextAI\Model\UserFieldsSelectedManager;

class ReviewNotice extends Template
{
    /**
     * @var UrlInterface
     */
    protected $urlBuilder;

    /**
     * Constructor
     *
     * @param Context $context
     * @param UserFieldsSelectedManager $userFieldsSelectedManager
     * @param array $data
     */
    public function __construct(
        Context $context,
        UserFieldsSelectedManager $userFieldsSelectedManager,
        array $data = []
    ) {
        $this->userFieldsSelectedManager = $userFieldsSelectedManager;
        $this->urlBuilder = $context->getUrlBuilder();
        parent::__construct($context, $data);
    }

    /**
     * Get notice message
     *
     * @return string
     */
    public function getNoticeMessage()
    {
        return __(
            'Your feedback helps us improve. Leave a quick review on <a href="%1" target="_blank">WriteText.ai</a>.',
            'https://writetext.ai/create-a-ticket/'
        );
    }

    /**
     * Get book notice
     */
    public function getBookNotice()
    {
        $message = sprintf("<p class='wtai-book-notice'><strong>%s</strong><br/>", __("Want to continue testing beyond the free trial?"));
        $message .= sprintf(
            '<a href="%s" target="_blank">%s</a> ',
            "https://writetext.ai/discovery-call", 
            __('Book a short call')
        );
        $message .= sprintf('%s</p>', __(' with our team so we can understand your setup and'
                . ' help you test WriteText.ai in a way that fits your real use case. Depending'
                . ' on the setup, we may enable additional testing credits to support more thorough testing.'));
        $message .= sprintf('<p>%s <a href="%s" target="_blank">%s</a>.</p>', __("If you've already had a chance to use WriteText.ai, we'd appreciate a quick review on "), "https://writetext.ai/create-a-ticket/", __('WriteText.ai'));
        return $message;
    }

    /**
     * Get dismiss URL for AJAX request
     *
     * @return string
     */
    public function getDismissUrl(): string
    {
        return $this->urlBuilder->getUrl('wtai/settings/save');
    }

    /**
     * Check if notice is visible
     *
     * @return bool
     */
    public function isVisible(): bool
    {
        return !$this->userFieldsSelectedManager->checkUserFieldsSelected(
            UserFieldsSelectedManager::ACTION_TYPE_REVIEW_NOTICE_DISMISSED,
            '',
            ''
        );
    }
}
