<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Block\Adminhtml\Grid;

use Magento\Backend\Block\Template\Context;
use WriteTextAI\WriteTextAI\ViewModel\Settings;

class GenerateButton extends \Magento\Backend\Block\Template
{
    /**
     * @var string
     */
    protected $_template = 'WriteTextAI_WriteTextAI::grid/massactions/generate_button.phtml';

    /**
     * @var Settings
     */
    protected $settings;

    /**
     * Constructor
     *
     * @param Context $context
     * @param Settings $settings
     * @param array $data
     */
    public function __construct(
        Context $context,
        Settings $settings,
        array $data = []
    ) {
        $this->settings = $settings;
        parent::__construct($context, $data);
    }

    /**
     * Get credits
     *
     * @return array
     */
    public function getCredits()
    {
        return $this->settings->getSettings('credits');
    }

    /**
     * Get rules
     *
     * @return array
     */
    public function getRules()
    {
        return $this->settings->getSettings('rules');
    }
}
