<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Block\Adminhtml;

use Magento\Backend\Block\Template\Context;
use Magento\Framework\Module\ModuleListInterface;
use WriteTextAI\WriteTextAI\Helper\Data;

class Footer extends \Magento\Backend\Block\Template
{
    public const MODULE_NAME = 'WriteTextAI_WriteTextAI';

    /**
     * @var ModuleListInterface
     */
    protected $moduleList;

    /**
     * @var Data
     */
    protected $helper;

    /**
     * Constructor
     *
     * @param Context $context
     * @param ModuleListInterface $moduleList
     * @param Data $helper
     * @param array $data
     */
    public function __construct(
        Context $context,
        ModuleListInterface $moduleList,
        Data $helper,
        array $data = []
    ) {
        $this->moduleList = $moduleList;
        $this->helper = $helper;
        parent::__construct($context, $data);
    }

    /**
     * Get module version
     *
     * @return string
     */
    public function getModuleVersion()
    {
        return $this->moduleList->getOne(self::MODULE_NAME)['setup_version'];
    }

    /**
     * Get API auth URL
     *
     * @return string
     */
    public function getApiAuthUrl()
    {
        return $this->helper->getApiAuthUrl();
    }

    /**
     * Get KO dev value
     *
     * @return string
     */
    public function getKoDev()
    {
        return $this->helper->getKoDev();
    }

    /**
     * Get build no
     *
     * @return string
     */
    public function getBuildNo()
    {
        return $this->helper->getBuildNo();
    }
}
