<?php
declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api;

/**
 * Interface ImageApiInterface
 * API endpoint for retrieving product images with alt text
 */
interface ImageApiInterface
{
    /**
     * Get product images with alt text
     *
     * @param int $recordId
     * @param string $type
     * @param int|null $storeId
     * @param string|null $language
     * @param bool|null $withAltText
     * @param bool|null $withTemplate
     * @return \Magento\Framework\DataObject
     */
    public function getImages(
        $recordId,
        $type,
        $storeId = null,
        $language = null,
        $withAltText = null,
        $withTemplate = null
    );
}
