<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api;

use Magento\Framework\Api\SearchCriteriaInterface;

interface FullAutomationRequestsRepositoryInterface
{

    /**
     * Save full_automation_requests
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\FullAutomationRequestsInterface $fullAutomationRequests
     * @return \WriteTextAI\WriteTextAI\Api\Data\FullAutomationRequestsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(
        \WriteTextAI\WriteTextAI\Api\Data\FullAutomationRequestsInterface $fullAutomationRequests
    );

    /**
     * Retrieve full_automation_requests
     *
     * @param string $fullAutomationRequestsId
     * @return \WriteTextAI\WriteTextAI\Api\Data\FullAutomationRequestsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function get($fullAutomationRequestsId);

    /**
     * Retrieve full_automation_requests matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \WriteTextAI\WriteTextAI\Api\Data\FullAutomationRequestsSearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    );

    /**
     * Delete full_automation_requests
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\FullAutomationRequestsInterface $fullAutomationRequests
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(
        \WriteTextAI\WriteTextAI\Api\Data\FullAutomationRequestsInterface $fullAutomationRequests
    );

    /**
     * Delete full_automation_requests by ID
     *
     * @param string $fullAutomationRequestsId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById($fullAutomationRequestsId);
}
