/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'uiComponent',
    'mage/translate',
    'Magento_Ui/js/modal/modal'
], function ($, Component, $t) {
    'use strict';

    /**
     * @var {Component} self
     */
    var self;

    return Component.extend({
        defaults: {
            unlockPremiumUrl: '',
            allFeaturesUrl: '',
            premiumPopupModal: null,
            selectors: {
                premiumPopupModalSelector: '.wtai-premium-popup-modal',
                premiumPopupTriggerSelector: 'span.wtai-premium',
                premiumPopupOverlaySelector: '.wtai-premium-popup-overlay',
                setupPremiumPopupTriggerSelector: '.wtai-premium-badge',
                stopAdsSelector: '.wtai-stop-ads'
            },
            classes: {
                modalClass: 'wtai-premium-popup-modal',
                overlayClass: 'wtai-premium-popup-overlay'
            }
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super().observe([]);
    
            return this;
        },
    
        /** @inheritdoc */
        initialize: function () {
            this._super();
    
            self = this;
    
            this.initModal();
        },

        /**
         * Initialize history log modal.
         */
        initModal: function () {
            this.premiumPopup = $(this.selectors.premiumPopupModalSelector).modal({
                title: $t('Unlock Pro Features'),
                subTitle: $t("Want to automate your workflow, optimize for search, and save hours on content? Pro gives you access to:"),
                innerScroll: true,
                modalClass: self.classes.modalClass,
                overlayClass: self.classes.overlayClass,
                buttons: [{
                    text: $t('See all Pro features'),
                    class: 'wtai-secondary-action-premium',
                    click: function () {
                        window.open(self.allFeaturesUrl, '_blank');
                    }
                },{
                    text: $t('Upgrade now'),
                    class: 'wtai-action-premium',
                    click: function () {
                        window.open(self.unlockPremiumUrl, '_blank');
                    }
                }],
                closed: function () {
                    $(self.selectors.premiumPopupOverlaySelector).remove();
                }
            });

            $(this.selectors.premiumPopupModalSelector).css('display', 'block');

            $(document).on(
                'click',
                `${self.selectors.premiumPopupTriggerSelector},
                ${self.selectors.stopAdsSelector},
                .wtai-disabled-bulk-action`,
                function (event) {
                    self.premiumPopup.modal('openModal');
                }
            );
        }
    });
});
