/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'ko',
    'uiComponent',
    'WriteTextAI_WriteTextAI/js/model/pro-badge',
    'Magento_Ui/js/modal/modal'
], function ($, ko, Component, proBadge) {
    'use strict';

    /**
     * @var {Component} self
     */
    var self;

    return Component.extend({
        defaults: {
            selectors: {
                modal: '.wtai-end-trial-popup-modal',
                overlay: '.wtai-end-trial-popup-overlay',
            },
            classes: {
                modal: 'wtai-end-trial-popup-modal',
                overlay: 'wtai-end-trial-popup-overlay'
            }
        },

        popup: null,
    
        /** @inheritdoc */
        initialize: function () {
            this._super();
    
            self = this;
    
            this.initModal();

            this.showPopup.subscribe(function (showPopup) {
                if (showPopup) {
                    self.popup.modal('openModal');
                }
            });
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super().observe([]);

            this.showPopup = ko.computed(function () {
                return proBadge.showEndTrial();
            }, this);
    
            return this;
        },

        /**
         * Initialize history log modal.
         */
        initModal: function () {
            this.popup = $(this.selectors.modal).modal({
                innerScroll: true,
                modalClass: self.classes.modal,
                overlayClass: self.classes.overlay,
                clickableOverlay: false,
                buttons: [],
                closed: function () {
                    self.popup.modal('openModal');
                },
                opened: function () {
                    $(self.selectors.modal + ' .modal-header button.action-close').hide();
                },
                keyEventHandlers: {
                    escapeKey: function () {
                        return; }
                }
            });

            $(this.selectors.modal).css('display', 'block');

            if (this.showPopupOnLoad) {
                this.popup.modal('openModal');
            }
        }
    });
});
