/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'underscore',
    'Magento_Ui/js/form/element/select'
], function (
    $,
    _,
    Select
) {
    'use strict';

    /**
     * @var {Component} self
     */
    var self;

    return Select.extend({
        /** @inheritdoc */
        initialize: function () {
            this._super();
            
            self = this;

            var storeIdParam = self.getParameterValueByName('wtai-store-id');
            if (storeIdParam) {
                if (storeIdParam !== '0') {
                    this.value(storeIdParam);
                } else {
                    this.value('');
                }
            }

            return this;
        },

        /**
         * Get parameter by name
         *
         * @param {String} name
         *
         * @returns {String}
         */
        getParameterValueByName: function (name) {
            var url = new URL(window.location.href),
                searchParams = new URLSearchParams(url.search),
                value = searchParams.get(name);

            return value ? value : '';
        }
    });
});
