/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'underscore',
    'WriteTextAI_WriteTextAI/js/model/edit/keywords/keyword-analysis',
    'WriteTextAI_WriteTextAI/js/model/edit/keywords/error-messages',
    "jquery/ui",
    "Magento_Theme/js/sortable",
    "wtaiJqueryUiTouchPunch"
], function (
    $,
    _,
    keywordAnalysis,
    errorMessagesModel
) {
    'use strict';

    /**
     * Open empty custom pipeline
     *
     * @param {*} self
     *
     * @returns {void}
     */
    function openEmptyCustom(self)
    {
        var totalPipeline = self.customPipelines().length + self.pipelines().length;
        if (totalPipeline >= self.maxNumberOfKeywordPipeline) {
            return;
        }
        if (!self.editKeywordPipelineVisible() && !keywordAnalysis.editKeywordRankingVisible()) {
            var newCustom = {
                "name": "Custom",
                "autogenerated": false,
                "keywords": {},
                "new": true
            };
            
            self.editKeywordPipeline(newCustom);
            self.editKeywordPipelineVisible(true);
            $(self.selectors.editPipeline).sortable("refresh");
        }
    }

    /**
     * Close empty custom pipeline
     *
     * @param {*} self
     *
     * @returns {void}
     */
    function closeEmptyCustom(self)
    {
        if (self.editKeywordPipeline().keywords === undefined) {
            return;
        }
        var hasKeyword = Object.keys(self.editKeywordPipeline().keywords).length > 0;
        if (self.editKeywordPipelineVisible() && !hasKeyword) {
            self.closeEditPipeline();
        }
    }

    /**
     * Restore previous pipeline request
     *
     * @param {Object} self
     *
     * @returns {void}
     */
    function restorePreviousPipelineRequest(self)
    {
        self.showEmptyLoader(true);
        self.ongoingProcessing(true);

        errorMessagesModel.messages([]);

        $.ajax({
            url: self.restorePreviousPipelineUrl,
            type: 'POST',
            data: {
                'store_id': self.storeId(),
                'record_id': self.recordId(),
                'entity_type': self.entityType
            },
            dataType: 'json',
            showLoader: false,
            success: function (response) {
                if (response.success) {
                    /*
                    var optimizationData = keywordAnalysis.optimizationData();
                    var pipelines = optimizationData.pipelines;
                    var previousPipeline = response.api_response.pipeline;
                    var newCount = response.api_response.availableClustersToRestore;

                    pipelines.push(previousPipeline);
                    optimizationData.pipelines = pipelines;
                    optimizationData.availableClustersToRestore = newCount;
                    keywordAnalysis.optimizationData(optimizationData);
                    */
                    self.getOptimization();
                } else {
                    if (response.error) {
                        errorMessagesModel.messages.push(response.error);
                    }
                }
            }
        }).always(function () {
            self.showEmptyLoader(false);
            self.ongoingProcessing(false);
        });
    }

    return {
        openEmptyCustom: openEmptyCustom,
        closeEmptyCustom: closeEmptyCustom,
        restorePreviousPipelineRequest: restorePreviousPipelineRequest
    };
});