/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'ko',
    'uiComponent',
    'underscore',
    'WriteTextAI_WriteTextAI/js/categories/model/edit/representative-products',
    'WriteTextAI_WriteTextAI/js/model/edit/settings',
    'WriteTextAI_WriteTextAI/js/model/total-credits',
    'WriteTextAI_WriteTextAI/js/model/edit/keywords/keywords',
], function ($, ko, Component, _, representativeProducts, settings, totalCredits, keywordsData) {
    'use strict';

    /**
     * @var {Component} self
     */
    var self;

    return Component.extend({
        defaults: {
            guideSteps: false,
            langguage: '',
            country: '',
            freeTrialMembershipType: 'FreeTrial'
        },

        isGuideStepsChange: false,

        /** @inheritdoc */
        initialize: function () {
            this._super();

            self = this;

            settings.guideSteps.subscribe(function (guideSteps) {
                self.guideSteps(guideSteps);
            });

            keywordsData.language.subscribe(function (language) {
                self.language(language);
            });

            keywordsData.country.subscribe(function (country) {
                self.country(country);
            });
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super()
                .observe([
                    'guideSteps',
                    'language',
                    'country'
                ]);

            this.representativeProductsCount = ko.computed(function () {
                let products = representativeProducts.selected() || [];

                return "(" + products.length + "/" + this.rules.maxRepresentativeProducts + ")";
            }, this);

            this.showAds = ko.computed(function () {
                return totalCredits.membershipType() === this.freeTrialMembershipType;
            }, this);

            this.hasProAccess = ko.computed(function () {
                return totalCredits.hasProAccess();
            }, this);
            
            return this;
        }
    });
});
