/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define(['ko', 'domReady!'], function (ko) {
    'use strict';

    var messages = ko.observable({
        page_title: {},
        page_description: {},
        category_description: {}
        }),
        index = ko.observable({
            page_title: 0,
            page_description: 0,
            category_description: 0
        }),
        fieldsGenerated = ko.observable({
            page_title: null,
            page_description: null,
            category_description: null
        }),
        errorFields = ko.observableArray([]),
        errorMessage = ko.observable(''),
        selectedFields = ko.observableArray([]),
        generating = ko.observable(false),
        showMessage = ko.observable(false),
        message = ko.observable(''),
        singleGeneratingStatuses = ko.observableArray([]),
        
        /* SignalR Connection Status */
        connectionStatus = ko.observable('Disconnected'), /* Disconnected, Connecting, Connected, Reconnecting */
        connectionState = ko.observable(''), /* Raw SignalR connection state */
        isConnected = ko.observable(false),
        lastConnectionTime = ko.observable(null),
        retryAttempts = ko.observable(0),
        connectionError = ko.observable('');

    return {
        messages: messages,
        index: index,
        fieldsGenerated: fieldsGenerated,
        errorFields: errorFields,
        errorMessage: errorMessage,
        selectedFields: selectedFields,
        generating: generating,
        showMessage: showMessage,
        message: message,
        singleGeneratingStatuses: singleGeneratingStatuses,
        
        /* SignalR Connection Status */
        connectionStatus: connectionStatus,
        connectionState: connectionState,
        isConnected: isConnected,
        lastConnectionTime: lastConnectionTime,
        retryAttempts: retryAttempts,
        connectionError: connectionError
    };
});
