/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'ko',
    'underscore',
    'Magento_Ui/js/grid/columns/actions',
    'WriteTextAI_WriteTextAI/js/model/history-log',
    'WriteTextAI_WriteTextAI/js/model/edit/product',
    'WriteTextAI_WriteTextAI/js/model/edit/keywords/keyword-analysis',
    'WriteTextAI_WriteTextAI/js/model/grid/reference-products',
    'WriteTextAI_WriteTextAI/js/categories/model/edit'
], function (
    $,
    ko,
    _,
    Column,
    historyLog,
    product,
    keywordAnalysis,
    referenceProducts,
    editData
) {
    'use strict';

    return Column.extend({
        defaults: {
            ids: [],
            users: [],
            currentUser: {},
            listens: {
                ids: 'updateIds',
                users: 'updateUsers'
            }
        },

        /** @inheritdoc */
        initialize: function () {
            this._super();
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super()
                .track([
                    'ids',
                    'users',
                    'currentUser'
                ]);

            return this;
        },

        /** @inheritdoc */
        defaultCallback: function (
            actionIndex,
            recordId,
            action
        ) {
            var category = {
                categoryId: recordId,
                storeId: action.store_id
            };
            
            switch (actionIndex) {
                case 'edit':
                    editData.currentCategory(category);
                    product.storeId(action.store_id); /** Update store id in transfer prompt */
                    break;
             
                default:
                    this._super(
                        actionIndex,
                        recordId,
                        action
                    );
                    break;
            }
        },

        /**
         * Update ids.
         */
        updateIds: function () {
            editData.ids(this.ids);
        },

        /**
         * Update history log users.
         */
        updateUsers: function () {
            historyLog.users(this.users);
        },

        /**
         * Check if action is disabled.
         *
         * @param {Object} action
         * @returns {Boolean}
         */
        isDisabled: function (action) {
            if (action.index === 'transfer') {
                return ko.computed(function () {
                    try {
                        var status = keywordAnalysis.statuses().find(function (status) {
                            return Number(status.storeId) === Number(referenceProducts.storeId()) &&
                                Number(status.recordId) === Number(action.recordId) &&
                                status.status === 'Running';
                        });
                        
                        if (status) {
                            return true;
                        }

                        return false;
                    } catch (error) {
                        return false;
                    }
                }, this);
            }
        }
    });
});
