/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'underscore',
    'Magento_Ui/js/form/element/ui-select',
    'WriteTextAI_WriteTextAI/js/categories/model/setup/data-mapping'
], function ($, _, Select, dataMapping) {
    'use strict';

    return Select.extend({
        defaults: {
            fieldName: ''
        },

        /** @inheritdoc */
        initialize: function () {
            this._super();

            this.setInitValue();

            return this;
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super().observe(['fieldName']);

            return this;
        },

        /** @inheritdoc */
        toggleOptionSelected: function (data) {
            var value = '',
                fieldName = '';

            this._super(data);

            value = this.value();
            fieldName = this.fieldName();

            switch (fieldName) {
                case 'category_description':
                    dataMapping.categoryDescription(value);
                    break;
            }

            return this;
        },

        /**
         * Set initial value
         */
        setInitValue: function () {
            var self = this,
                value = this.value(),
                fieldName = this.fieldName();

            switch (fieldName) {
                case 'category_description':
                    dataMapping.categoryDescription(value);
                    break;
            }
        },

        /**
         * Check if option is disabled
         *
         * @param {*} option
         * @return {Boolean}
         */
        isDisabled: function (option) {
            var fields = [
                dataMapping.categoryDescription(),
            ];
            return (
                _.contains(fields, option.value) &&
                this.value() !== option.value
            );
        }
    });
});
