/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'uiComponent',
    'underscore',
    'ko',
    'WriteTextAI_WriteTextAI/js/model/edit/product',
    'WriteTextAI_WriteTextAI/js/categories/model/edit/category',
    'WriteTextAI_WriteTextAI/js/categories/model/edit/image',
    'mage/template',
    'text!Magento_Ui/templates/grid/cells/thumbnail/preview.html',
    'Magento_Ui/js/modal/modal'
], function (
    $,
    Component,
    _,
    ko,
    product,
    category,
    categoryImageModel,
    mageTemplate,
    thumbnailPreviewTemplate
) {
    'use strict';

    /**
     * @var {Component} self
     */
    var self;

    return Component.extend({
        defaults: {
            categoryImageSelected: true
        },

        isCategoryImageSelectedChanged: false,

        /** @inheritdoc */
        initialize: function () {
            this._super();

            self = this;

            categoryImageModel.categoryImageSelected.subscribe(function (value) {
                this.isCategoryImageSelectedChanged = true;
                this.categoryImageSelected(value);
                this.isCategoryImageSelectedChanged = false;
            }, this);

            this.categoryImageSelected.subscribe(function (value) {
                if (!this.isCategoryImageSelectedChanged) {
                    categoryImageModel.categoryImageSelected(value);
                }
            }, this);
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super()
                .observe([
                    'categoryImageSelected'
                ]);

            this.useDefault = ko.computed(function () {
                return categoryImageModel.useDefault();
            });

            this.categoryImage = ko.computed(function () {
                return category.image();
            });

            this.storeId = ko.computed(function () {
                return product.storeId();
            });
            
            this.isAllStoreView = ko.computed(function () {
                return Number(this.storeId()) === Number(this.defaultStoreId);
            }, this);

            return this;
        },

        /**
         * Preview image.
         */
        preview: function () {
            var modalHtml = mageTemplate(
                thumbnailPreviewTemplate,
                {
                    src: self.categoryImage(),
                    alt: '',
                    link: '',
                    linkText: ''
                    }
            ),
                previewPopup = $('<div/>').html(modalHtml);

            previewPopup.modal({
                title: '',
                innerScroll: true,
                modalClass: '_image-box',
                buttons: []
            }).trigger('openModal');
        },

        /**
         * Save user preferences
         */
        savePreferences: function () {
            $.ajax({
                url: self.saveUrl,
                type: 'POST',
                data: {
                    category_image: self.categoryImageSelected(),
                    entity_type: 'category',
                    scope: 'edit'
                },
                dataType: 'json',
                showLoader: false,
                success: function (response) {
                    if (!response.success) {
                        console.log(response);
                    }
                }
            });
        },
    });
});
