<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\ViewModel;

use WriteTextAI\WriteTextAI\Model\ApiManager;

use WriteTextAI\WriteTextAI\Model\OptionSource\Filter\Fields;

class TemplateSettings implements \Magento\Framework\View\Element\Block\ArgumentInterface
{

    /**
     * @var ApiManager
     */
    protected $apiManager;

    /**
     * @var array
     */
    protected $templateSettings = [];

    /**
     * Constructor
     *
     * @param ApiManager $apiManager
     */
    public function __construct(
        ApiManager $apiManager
    ) {
        $this->apiManager = $apiManager;
    }

    /**
     * Get current template settings
     *
     * @param string $specificField
     *
     * @return array
     */
    public function getCurrentTemplateSettings($specificField = null)
    {
        $fieldConfig = [
            'page_title' => Fields::PAGE_TITLE,
            'page_description' => Fields::PAGE_DESCRIPTION,
            'product_description' => Fields::PRODUCT_DESCRIPTION,
            'short_product_description' => Fields::EXCERPT,
            'open_graph' => Fields::OPEN_GRAPH,
            'category_page_title' => Fields::CATEGORY_PAGE_TITLE,
            'category_page_description' => Fields::CATEGORY_PAGE_DESCRIPTION,
            'category_description' => Fields::CATEGORY_DESCRIPTION
        ];

        if (!$this->templateSettings) {
            $this->templateSettings = $this->apiManager->getCurrentTemplateSettings();
        }

        if ($this->templateSettings) {
            if ($specificField) {
                if (isset($this->templateSettings[$fieldConfig[$specificField]])) {
                    return $this->templateSettings[$fieldConfig[$specificField]]['selections'];
                }
            } else {
                return $this->templateSettings;
            }
        }

        return [];
    }
}
