<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use WriteTextAI\WriteTextAI\Model\GenerateOptionsManager;

class GenerateSettings implements ArgumentInterface
{
    /**
     * @var GenerateOptionsManager
     */
    protected $generateOptionsManager;

    /**
     * Constructor
     *
     * @param GenerateOptionsManager $generateOptionsManager
     */
    public function __construct(
        GenerateOptionsManager $generateOptionsManager
    ) {
        $this->generateOptionsManager = $generateOptionsManager;
    }

    /**
     * Get default tones
     *
     * @return array
     */
    public function getDefaultTones()
    {
        $tones = $this->generateOptionsManager->getOptions('tones');
        
        $defaultTones = array_filter($tones, function ($tone) {
            return $tone['default'];
        });

        return array_column($defaultTones, 'id');
    }

    /**
     * Get default styles
     *
     * @return array
     */
    public function getDefaultStyle()
    {
        $styles = $this->generateOptionsManager->getOptions('styles');
        
        $defaultStyles = array_filter($styles, function ($style) {
            return $style['default'];
        });

        $ids = array_column($defaultStyles, 'id');

        return array_shift($ids);
    }

    /**
     * Get default audiences
     *
     * @return array
     */
    public function getDefaultAudiences()
    {
        $audiences = $this->generateOptionsManager->getOptions('audience');
        
        $defaultAudiences = array_filter($audiences, function ($audience) {
            return $audience['default'];
        });

        return array_column($defaultAudiences, 'id');
    }
}
