<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Setup;

use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UninstallInterface;

class Uninstall implements UninstallInterface
{
    /**
     * Uninstall module
     *
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     */
    public function uninstall(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $this
            ->uninstallTables($setup)
            ->uninstallConfigData($setup);
    }

    /**
     * Uninstall tables
     *
     * @param SchemaSetupInterface $setup
     * @return $this
     */
    private function uninstallTables(SchemaSetupInterface $setup): self
    {
        $tablesToDrop = [
            "writetextai_writetextai_products_store",
            "writetextai_writetextai_settings",
            "writetextai_writetextai_user_fields_selected",
            "writetextai_writetextai_user_web_token",
            "writetextai_writetextai_bulk_generate_requests",
            "writetextai_writetextai_bulk_transfer_requests",
            "writetextai_writetextai_categories_store"
        ];

        foreach ($tablesToDrop as $table) {
            $setup->getConnection()->dropTable(
                $setup->getTable($table)
            );
        }

        return $this;
    }

    /**
     * Uninstall config data
     *
     * @param SchemaSetupInterface $setup
     * @return $this
     */
    private function uninstallConfigData(SchemaSetupInterface $setup): self
    {
        $configTable = $setup->getTable('core_config_data');
        $setup->getConnection()->delete($configTable, "`path` LIKE 'writetextai_settings%'");

        return $this;
    }
}
