<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */
declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Observer\Catalog;

use \Magento\Framework\Event\Observer;
use \Magento\Framework\Event\ObserverInterface;
use WriteTextAI\WriteTextAI\Model\NewRecordsManager;

class CategorySaveAfter implements ObserverInterface
{
    /**
     * @var NewRecordsManager
     */
    protected $newRecordsManager;

    public function __construct(
        NewRecordsManager $newRecordsManager
    ) {
        $this->newRecordsManager = $newRecordsManager;
    }

    /**
     * Execute observer
     *
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer): void
    {
        try {
            $category = $observer->getEvent()->getCategory();
            if ($category->isObjectNew()) {
                $categoryId = $category->getId();
                $this->newRecordsManager->saveNewRecords($categoryId, 'Category');
            }
        } catch (\Exception $e) {
            // Do nothing
        }
    }
}
