<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\OptionSource\Filter;

use WriteTextAI\WriteTextAI\Helper\Data;

class Fields
{
    /**
     * make sure the values match the ones in the api
     */
    public const PAGE_TITLE = 'page title';

    public const PAGE_DESCRIPTION = 'page description';

    public const PRODUCT_DESCRIPTION = 'product description';

    public const EXCERPT = 'excerpt';

    public const OPEN_GRAPH = 'open graph text';

    public const CATEGORY_PAGE_TITLE = 'category page title';

    public const CATEGORY_PAGE_DESCRIPTION = 'category page description';

    public const CATEGORY_DESCRIPTION = 'category description';

    public const CATEGORY_MAPPING = [
        'page_title' => self::CATEGORY_PAGE_TITLE,
        'page_description' => self::CATEGORY_PAGE_DESCRIPTION,
        'category_description' => self::CATEGORY_DESCRIPTION
    ];

    public const STATUS_MAPPING = [
        'generated' => 'Generate',
        'transferred' => 'Transferred,Magento'
    ];

    public const STATUSES = [
        'generated',
        'transferred'
    ];

    /**
     * @var Data
     */
    protected $helper;

    /**
     * Constructor
     *
     * @param Data $helper
     */
    public function __construct(
        Data $helper
    ) {
        $this->helper = $helper;
    }
}
