<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model;

use WriteTextAI\WriteTextAI\Helper\Data;
use WriteTextAI\WriteTextAI\Model\Config\Source\ProductAttributes;
use WriteTextAI\WriteTextAI\Model\Config\Source\ProductAttributes\Excluded;
use WriteTextAI\WriteTextAI\ViewModel\Settings;

class GenerateOptionsManager
{

    /**
     * @var Data
     */
    protected $helper;

    /**
     * @var ProductAttributes
     */
    protected $attributes;

    /**
     * @var Settings
     */
    protected $settings;

    /**
     * @param Data $helper
     * @param ProductAttributes $attributes
     * @param Settings $settings
     */
    public function __construct(
        Data $helper,
        ProductAttributes $attributes,
        Settings $settings
    ) {
        $this->helper = $helper;
        $this->attributes = $attributes;
        $this->settings = $settings;
    }

    /**
     * Get bulk generate options
     *
     * @param string $type
     * @return array
     */
    public function getOptions($type)
    {
        switch ($type) {
            case 'tones':
                $options = $this->settings->getSettings('tones');
                $tones = $this->helper->getTones();
                $defaultValues = $tones ? explode(",", (string) $tones) : [];
                break;
            case 'styles':
                $options = $this->settings->getSettings('styles');
                $styles = $this->helper->getStyles();
                $defaultValues = $styles ? explode(",", (string) $styles) : [];
                break;
            case 'audience':
                $options = $this->settings->getSettings('audiences');
                $audiences = $this->helper->getAudiences();
                $defaultValues = $audiences ? explode(",", (string) $audiences) : [];
                break;
            case 'attributes':
                $options = $this->attributes->toOptionArray();
                $attributes = $this->helper->getAttributesSettings('attributes');
                $defaultValues = $attributes ? explode(",", (string) $attributes) : [];
                break;
            default:
                $options = [];
                $defaultValues = [];
                break;
        }

        if ($type == 'attributes') {
            $options = $this->excludeAttributes($options);
            foreach ($options as &$option) {
                $option['default'] = false;
                if (in_array($option['value'], $defaultValues)) {
                    $option['default'] = true;
                }
            }
        } else {
            if (!empty($defaultValues)) {
                foreach ($options as &$option) {
                    $option['default'] = false; // unset default from api
                    if (in_array($option['id'], $defaultValues)) {
                        $option['default'] = true;
                    }
                }
            }
        }

        return $options;
    }

    /**
     * Exclude attributes
     *
     * @param array $attributes
     * @return array
     */
    protected function excludeAttributes($attributes)
    {
        $mappedAttributes = array_values((array)$this->helper->getMappingSettings());
        $exclude = array_merge(
            $mappedAttributes,
            Excluded::GENERATE_SETTINGS_EXCLUDE_ATTRIBUTES
        );

        foreach ($attributes as $key => $attribute) {
            if (in_array($attribute['value'], $exclude)) {
                unset($attributes[$key]);
            }
        }

        return $attributes;
    }
}
