<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class TriggerActions implements OptionSourceInterface
{
    public const WHEN_PAGE_IS_RANKING = 'when_page_is_ranking';
    
    public const AFTER_N_DAYS = 'after_n_days';

    public const NONE = 'none';

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        
        $options = [
            [
                'value' => self::WHEN_PAGE_IS_RANKING,
                'label' => __('When page is ranking within position 1 - N in the SERP')
            ],
            [
                'value' => self::AFTER_N_DAYS,
                'label' => __('After N day/s')
            ],
            [
                'value' => self::NONE,
                'label' => __('None')
            ]
        ];
        
        return $options;
    }
}
