<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use WriteTextAI\WriteTextAI\Model\SettingManager;
use WriteTextAI\WriteTextAI\Model\Api\Session as ApiSession;

class Tones implements OptionSourceInterface
{
    /**
     * @var SettingManager
     */
    protected $settingManager;

    /**
     * @var ApiSession
     */
    protected $apiSession;

    /**
     * Constructor
     *
     * @param SettingManager $settingManager
     * @param ApiSession $apiSession
     */
    public function __construct(
        SettingManager $settingManager,
        ApiSession $apiSession
    ) {
        $this->settingManager = $settingManager;
        $this->apiSession = $apiSession;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $language = $this->apiSession->getRegionIndependentLanguage();
        $tones = $this->settingManager->getSettings('tones', $language);
        
        $options = [];
        
        foreach ($tones as $tone) {
            $options[] = [
                'value' => $tone['id'],
                'label' => $tone['name']
            ];
        }
        
        return $options;
    }
}
