<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Config\Source\DefaultValues;

class Tones extends Base
{
    /**
     * Get default tones
     *
     * @return $string
     */
    public function getDefaultValues()
    {
        $locale = $this->getUserLocale();
        $tones = $this->settingManager->getSettings('tones', $locale);
        
        $values = [];
        
        foreach ($tones as $tone) {
            if ($tone['default'] == true) {
                $values[] = $tone['id'];
            }
        }
        
        return implode(',', $values);
    }
}
