<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Config\Source\DefaultValues;

class ProductTexts extends Base
{
    /**
     * Get default styles
     *
     * @return $string
     */
    public function getDefaultValues()
    {
        $productTexts = [
            "page_title" => __('Meta title'),
            "page_description" => __('Meta description'),
            "product_description" => __('Product description'),
            "short_product_description" => __('Product short description')
        ];

        if ($this->helper->getCustomOpenGraph()) {
            $productTexts['open_graph'] = __('Open Graph text');
        }

        $values = [];
        foreach ($productTexts as $key => $value) {
            $values[] = $key;
        }
        
        return implode(',', $values);
    }
}
