<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Config\Source\DefaultValues;

class Base extends \Magento\Framework\App\Config\Value
{
    /**
     * @var \WriteTextAI\WriteTextAI\Model\SettingManager
     */
    protected $settingManager;

    /**
     * @var \WriteTextAI\WriteTextAI\Model\Api\Session
     */
    protected $apiSession;

    /**
     * @var \WriteTextAI\WriteTextAI\Helper\Data
     */
    protected $helper;

    /**
     * Tones constructor
     *
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $config
     * @param \Magento\Framework\App\Cache\TypeListInterface $cacheTypeList
     * @param \WriteTextAI\WriteTextAI\Model\SettingManager $settingManager
     * @param \WriteTextAI\WriteTextAI\Model\Api\Session $apiSession
     * @param \WriteTextAI\WriteTextAI\Helper\Data $helper
     * @param \Magento\Framework\Model\ResourceModel\AbstractResource|null $resource
     * @param \Magento\Framework\Data\Collection\AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\App\Config\ScopeConfigInterface $config,
        \Magento\Framework\App\Cache\TypeListInterface $cacheTypeList,
        \WriteTextAI\WriteTextAI\Model\SettingManager $settingManager,
        \WriteTextAI\WriteTextAI\Model\Api\Session $apiSession,
        \WriteTextAI\WriteTextAI\Helper\Data $helper,
        ?\Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        ?\Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->settingManager = $settingManager;
        $this->apiSession = $apiSession;
        $this->helper = $helper;
        parent::__construct(
            $context,
            $registry,
            $config,
            $cacheTypeList,
            $resource,
            $resourceCollection,
            $data
        );
    }

    /**
     * Processing object after load data
     *
     * @return void
     */
    protected function _afterLoad()
    {
        $value = $this->getValue();
        if (!$value) {
            $this->setValue($this->getDefaultValues());
        }
    }

    /**
     * Get user locale
     *
     * @return string
     */
    public function getUserLocale()
    {
        return $this->apiSession->getRegionIndependentLanguage();
    }
}
