<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Config\Source\DefaultValues;

class Audiences extends Base
{
    /**
     * Get default audiences
     *
     * @return $string
     */
    public function getDefaultValues()
    {
        $locale = $this->getUserLocale();
        $audiences = $this->settingManager->getSettings('audiences', $locale);
        
        $values = [];
        
        foreach ($audiences as $audience) {
            if ($audience['default'] == true) {
                $values[] = $audience['id'];
            }
        }
        
        return implode(',', $values);
    }
}
