<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class AutoTransferSchedule implements OptionSourceInterface
{

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options = [];
        
        for ($hour = 0; $hour < 24; $hour++) {
            $hourPadded = str_pad((string)$hour, 2, '0', STR_PAD_LEFT);
            $timeLabel = $hourPadded . ':00';
            $cronValue = "00 {$hourPadded} * * *";
            
            $options[] = [
                'value' => $cronValue,
                'label' => __($timeLabel)
            ];
        }
        
        return $options;
    }
}
