<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Model;

use Magento\Framework\Model\AbstractModel;
use WriteTextAI\WriteTextAI\Api\Data\BulkTransferRequestsInterface;

class BulkTransferRequests extends AbstractModel implements BulkTransferRequestsInterface
{
    /**
     * @inheritDoc
     */
    public function _construct()
    {
        $this->_init(\WriteTextAI\WriteTextAI\Model\ResourceModel\BulkTransferRequests::class);
    }

    /**
     * @inheritDoc
     */
    public function getBulkTransferRequestsId()
    {
        return $this->getData(self::BULK_TRANSFER_REQUESTS_ID);
    }

    /**
     * @inheritDoc
     */
    public function setBulkTransferRequestsId($bulkTransferRequestsId)
    {
        return $this->setData(self::BULK_TRANSFER_REQUESTS_ID, $bulkTransferRequestsId);
    }

    /**
     * @inheritDoc
     */
    public function getUser()
    {
        return $this->getData(self::USER);
    }

    /**
     * @inheritDoc
     */
    public function setUser($user)
    {
        return $this->setData(self::USER, $user);
    }

    /**
     * @inheritDoc
     */
    public function getQueueIds()
    {
        return $this->getData(self::QUEUE_IDS);
    }

    /**
     * @inheritDoc
     */
    public function setQueueIds($queueIds)
    {
        return $this->setData(self::QUEUE_IDS, $queueIds);
    }

    /**
     * @inheritDoc
     */
    public function getCompletedIds()
    {
        return $this->getData(self::COMPLETED_IDS);
    }

    /**
     * @inheritDoc
     */
    public function setCompletedIds($completedIds)
    {
        return $this->setData(self::COMPLETED_IDS, $completedIds);
    }

    /**
     * @inheritDoc
     */
    public function getSuccessIds()
    {
        return $this->getData(self::SUCCESS_IDS);
    }

    /**
     * @inheritDoc
     */
    public function setSuccessIds($successIds)
    {
        return $this->setData(self::SUCCESS_IDS, $successIds);
    }

    /**
     * @inheritDoc
     */
    public function getStoresSelected()
    {
        return $this->getData(self::STORES_SELECTED);
    }

    /**
     * @inheritDoc
     */
    public function setStoresSelected($storesSelected)
    {
        return $this->setData(self::STORES_SELECTED, $storesSelected);
    }

    /**
     * @inheritDoc
     */
    public function getStoreFilter()
    {
        return $this->getData(self::STORE_FILTER);
    }

    /**
     * @inheritDoc
     */
    public function setStoreFilter($storeFilter)
    {
        return $this->setData(self::STORE_FILTER, $storeFilter);
    }

    /**
     * @inheritDoc
     */
    public function getFieldsSelected()
    {
        return $this->getData(self::FIELDS_SELECTED);
    }

    /**
     * @inheritDoc
     */
    public function setFieldsSelected($fieldsSelected)
    {
        return $this->setData(self::FIELDS_SELECTED, $fieldsSelected);
    }

    /**
     * @inheritDoc
     */
    public function getIsCancelled()
    {
        return $this->getData(self::IS_CANCELLED);
    }

    /**
     * @inheritDoc
     */
    public function setIsCancelled($isCancelled)
    {
        return $this->setData(self::IS_CANCELLED, $isCancelled);
    }

    /**
     * @inheritDoc
     */
    public function getTransferredAt()
    {
        return $this->getData(self::TRANSFERRED_AT);
    }

    /**
     * @inheritDoc
     */
    public function setTransferredAt($transferredAt)
    {
        return $this->setData(self::TRANSFERRED_AT, $transferredAt);
    }

    /**
     * @inheritDoc
     */
    public function getErrorIds()
    {
        return $this->getData(self::ERROR_IDS);
    }

    /**
     * @inheritDoc
     */
    public function setErrorIds($errorIds)
    {
        return $this->setData(self::ERROR_IDS, $errorIds);
    }

    /**
     * @inheritDoc
     */
    public function getSkippedIds()
    {
        return $this->getData(self::SKIPPED_IDS);
    }

    /**
     * @inheritDoc
     */
    public function setSkippedIds($skippedIds)
    {
        return $this->setData(self::SKIPPED_IDS, $skippedIds);
    }

    /**
     * @inheritDoc
     */
    public function getStartedAt()
    {
        return $this->getData(self::STARTED_AT);
    }

    /**
     * @inheritDoc
     */
    public function setStartedAt($startedAt)
    {
        return $this->setData(self::STARTED_AT, $startedAt);
    }
}
