<?php
/**
 * Copyright ©  All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Model;

use Magento\Framework\Model\AbstractModel;
use WriteTextAI\WriteTextAI\Api\Data\BulkKeywordAnalysisRequestsInterface;

class BulkKeywordAnalysisRequests extends AbstractModel implements BulkKeywordAnalysisRequestsInterface
{

    /**
     * @inheritDoc
     */
    public function _construct()
    {
        $this->_init(\WriteTextAI\WriteTextAI\Model\ResourceModel\BulkKeywordAnalysisRequests::class);
    }

    /**
     * @inheritDoc
     */
    public function getBulkkeywordanalysisrequestsId()
    {
        return $this->getData(self::BULKKEYWORDANALYSISREQUESTS_ID);
    }

    /**
     * @inheritDoc
     */
    public function setBulkkeywordanalysisrequestsId($bulkkeywordanalysisrequestsId)
    {
        return $this->setData(self::BULKKEYWORDANALYSISREQUESTS_ID, $bulkkeywordanalysisrequestsId);
    }

    /**
     * @inheritDoc
     */
    public function getUser()
    {
        return $this->getData(self::USER);
    }

    /**
     * @inheritDoc
     */
    public function setUser($user)
    {
        return $this->setData(self::USER, $user);
    }

    /**
     * @inheritDoc
     */
    public function getRequestId()
    {
        return $this->getData(self::REQUEST_ID);
    }

    /**
     * @inheritDoc
     */
    public function setRequestId($requestId)
    {
        return $this->setData(self::REQUEST_ID, $requestId);
    }

    /**
     * @inheritDoc
     */
    public function getRecordId()
    {
        return $this->getData(self::RECORD_ID);
    }

    /**
     * @inheritDoc
     */
    public function setRecordId($recordId)
    {
        return $this->setData(self::RECORD_ID, $recordId);
    }

    /**
     * @inheritDoc
     */
    public function getEntityType()
    {
        return $this->getData(self::ENTITY_TYPE);
    }

    /**
     * @inheritDoc
     */
    public function setEntityType($entityType)
    {
        return $this->setData(self::ENTITY_TYPE, $entityType);
    }

    /**
     * @inheritDoc
     */
    public function getStoreId()
    {
        return $this->getData(self::STORE_ID);
    }

    /**
     * @inheritDoc
     */
    public function setStoreId($storeId)
    {
        return $this->setData(self::STORE_ID, $storeId);
    }
}
