<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model;

use Magento\Framework\Model\AbstractModel;
use WriteTextAI\WriteTextAI\Api\Data\AiProductInterface;
use WriteTextAI\WriteTextAI\Model\ResourceModel\AiProduct as AiProductResource;

class AiProduct extends AbstractModel implements AiProductInterface
{
    /**
     * @inheritDoc
     */
    protected function _construct()
    {
        $this->_init(AiProductResource::class);
    }
    
    /**
     * @inheritDoc
     */
    public function setProductId($productId)
    {
        return $this->setData(self::PRODUCT_ID, $productId);
    }
    
    /**
     * @inheritDoc
     */
    public function getProductId()
    {
        return $this->getData(self::PRODUCT_ID);
    }
    
    /**
     * @inheritDoc
     */
    public function setStoreId($storeId)
    {
        return $this->setData(self::STORE_ID, $storeId);
    }
    
    /**
     * @inheritDoc
     */
    public function getStoreId()
    {
        return $this->getData(self::STORE_ID);
    }

    /**
     * @inheritDoc
     */
    public function setProductAttributesSelected($productAttributesSelected)
    {
        return $this->setData(self::PRODUCT_ATTRIBUTES_SELECTED, $productAttributesSelected);
    }

    /**
     * @inheritDoc
     */
    public function getProductAttributesSelected()
    {
        return $this->getData(self::PRODUCT_ATTRIBUTES_SELECTED);
    }

    /**
     * @inheritDoc
     */
    public function setOtherDetailsChecked($otherDetailsChecked)
    {
        return $this->setData(self::OTHER_DETAILS_CHECKED, $otherDetailsChecked);
    }

    /**
     * @inheritDoc
     */
    public function getOtherDetailsChecked()
    {
        return $this->getData(self::OTHER_DETAILS_CHECKED);
    }

    /**
     * @inheritDoc
     */
    public function setOtherDetails($otherDetails)
    {
        return $this->setData(self::OTHER_DETAILS, $otherDetails);
    }

    /**
     * @inheritDoc
     */
    public function getOtherDetails()
    {
        return $this->getData(self::OTHER_DETAILS);
    }
    
    /**
     * @inheritDoc
     */
    public function setGeneratedAt($generatedAt)
    {
        return $this->setData(self::GENERATED_AT, $generatedAt);
    }

    /**
     * @inheritDoc
     */
    public function getGeneratedAt()
    {
        return $this->getData(self::GENERATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function setEditedAt($editedAt)
    {
        return $this->setData(self::EDITED_AT, $editedAt);
    }
    
    /**
     * @inheritDoc
     */
    public function getEditedAt()
    {
        return $this->getData(self::EDITED_AT);
    }
    
    /**
     * @inheritDoc
     */
    public function setTransferredAt($transferredAt)
    {
        return $this->setData(self::TRANSFERRED_AT, $transferredAt);
    }
    
    /**
     * @inheritDoc
     */
    public function getTransferredAt()
    {
        return $this->getData(self::TRANSFERRED_AT);
    }

    /**
     * @inheritDoc
     */
    public function setRefreshAt($refreshAt)
    {
        return $this->setData(self::REFERESH_AT, $refreshAt);
    }

    /**
     * @inheritDoc
     */
    public function getRefreshAt()
    {
        return $this->getData(self::REFERESH_AT);
    }

    /**
     * @inheritDoc
     */
    public function getReviewedAt()
    {
        return $this->getData(self::REVIEWED_AT);
    }

    /**
     * @inheritDoc
     */
    public function setReviewedAt($reviewedAt)
    {
        return $this->setData(self::REVIEWED_AT, $reviewedAt);
    }
}
