<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Logger;

use WriteTextAI\WriteTextAI\Helper\Data;

class CronLogger extends \Monolog\Logger
{
    /**
     * @var Data
     */
    protected $helper;

    /**
     * Logger constructor.
     *
     * @param Data $helper
     * @param string $name
     * @param array $handlers
     * @param array $processors
     */
    public function __construct(
        Data $helper,
        string $name,
        $handlers = [],
        $processors = []
    ) {
        $this->helper = $helper;

        parent::__construct(
            $name,
            $handlers,
            $processors
        );
    }

    /**
     * Logs request
     *
     * @param string $request
     * @param array $body
     *
     * @return void
     */
    public function logRequest($stringMessage = '')
    {
        if ($this->helper->isLoggerEnabled()) {
            $this->info($stringMessage);
        }
    }
}
