<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Helper;

use Magento\Framework\App\Helper\AbstractHelper;

class Generate extends AbstractHelper
{
    /**
     * Concat text
     *
     * @param string $text
     * @param int $maxLength
     * @return string
     */
    public function concatText($text, $maxLength)
    {
        return substr((string)$text, 0, $maxLength);
    }

    /**
     * Update default
     *
     * @param array $settings
     * @param array $defaults
     * @return array
     */
    public function updateDefault($settings, $defaults)
    {
        if (empty($defaults)) {
            return $settings;
        }
        
        $result = [];
        foreach ($settings as $setting) {
            $result[] = [
                'id' => $setting['id'],
                'name' => $setting['name'],
                'default' => in_array($setting['id'], $defaults)
            ];
        }

        return $result;
    }
}
