<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Helper;

use Magento\Framework\Stdlib\DateTime\DateTime;
use Magento\Framework\Stdlib\DateTime\TimezoneInterface;

class Filters extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var TimezoneInterface
     */
    protected $timezone;

    /**
     * @var DateTime
     */
    protected $dateTime;

    /**
     * Constructor
     *
     * @param TimezoneInterface $timezone
     * @param DateTime $dateTime
     */
    public function __construct(
        TimezoneInterface $timezone,
        DateTime $dateTime
    ) {
        $this->timezone = $timezone;
        $this->dateTime = $dateTime;
    }

    /**
     * Get the start and end date of the last number of days
     *
     * @param int $numberOfDays
     * @return array
     */
    public function getLastNumberOfDays($numberOfDays)
    {
        // Get current date and time in UTC
        $currentDateTime = $this->dateTime->gmtDate();

        // Calculate the start date by subtracting the number of days from the current date
        $startDate = date('Y-m-d H:i:s', strtotime("-$numberOfDays days", strtotime($currentDateTime)));

        // Set the end date to the current date and time
        $endDate = $currentDateTime;

        return [
            'start_date' => $startDate,
            'end_date' => $endDate
        ];
    }
}
