<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

 namespace WriteTextAI\WriteTextAI\Cron;

use WriteTextAI\WriteTextAI\Model\NewRecordsManager;
use WriteTextAI\WriteTextAI\Cron\BaseCron;
use Magento\User\Model\UserFactory;
use WriteTextAI\WriteTextAI\Model\Api\Session as ApiSession;
use Magento\Framework\App\Config\ScopeConfigInterface;

class NewRecordsProduct extends BaseCron
{
    /**
     * @var NewRecordsManager
     */
    protected $newRecordsManager;
    
    /**
     * Constructor
     *
     * @param NewRecordsManager $newRecordsManager
     * @param UserFactory $userFactory
     * @param ApiSession $apiSession
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        NewRecordsManager $newRecordsManager,
        UserFactory $userFactory,
        ApiSession $apiSession,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->newRecordsManager = $newRecordsManager;
        parent::__construct($userFactory, $apiSession, $scopeConfig);
    }

    /**
     * Execute the cron
     *
     * @return void
     */
    public function execute(): void
    {
        try {
            $productRecords = $this->newRecordsManager->sendNewRecords('Product');
            $categoryRecords = $this->newRecordsManager->sendNewRecords('Category');
            if (!empty($productRecords) || !empty($categoryRecords)) {
                $this->newRecordsManager->sendEmail(); //only send email once after category cron
            }
        } catch (\Exception $e) {
            //do nothing
            return;
        }
    }
}
